#include "bini.h"
#include <stdio.h>
#include <stdlib.h>
#include <direct.h>
#include <vector>
#include <fstream>
#include <map>

using namespace std;

//======================================
//@define
//======================================
#define BYTE unsigned char
#define MAP map //unordered_mapmapɕύX܂
#define BINI_OPEN_MAX (25600) //ɊJt@C
#define PASS_MAX	(256+1)//I[vpX̍ő啶

#ifdef _UNICODE
	#define PSTRING wstring
	#define MKDIR _wmkdir
#else
	#define PSTRING string
	#define MKDIR _mkdir
#endif

//======================================
//@Ŏg֐
//======================================
extern int DirectoryMake(const TCHAR Path[]);
extern PSTRING GetFileName(const TCHAR Path[]);

extern long long int Compress(vector<BYTE>& str);
extern long long int Expand(vector<BYTE>& str);

extern void Encode(vector<BYTE>& str,const char pass[9]="\0");
extern void Decode(vector<BYTE>& str,const char pass[9]="\0");

extern unsigned long long int GetHash(vector<BYTE>& str,unsigned start=0);
extern unsigned long long int SetPassToHash(unsigned long long int hash,const char pass[9]);

extern unsigned long long int ByteToULLInt(BYTE* ptr);
extern long long int ByteToLLInt(BYTE* ptr);
extern unsigned int ByteToUInt(BYTE* ptr);
extern double ByteToDouble(BYTE* ptr);
extern void ByteToString(BYTE* ptr,string& str,unsigned int size);

template<typename type> BYTE ToByteGetAny(type from,int num){
	return *(((BYTE*)&from)+num);
};
template<typename type> void AddDataForByteVector(vector<BYTE>& vec,type from){
	for(int i=0;i<sizeof(type);i++){
		vec.push_back(ToByteGetAny(from,i));
	}
}
extern void AddStringForByteVector(vector<BYTE>& vec,const string& str);

//======================================
//@O[oϐƂNXƂ
//======================================
#include "bini_class_global.hpp"//̂ŏoĂ܂

//======================================
//@nh|C^ϊAj[Nȃnh̎擾AcczAĔj
//======================================
bini* GetBiniPtr(int Handle){
	bini* ret;
	if(bini_ptr.count(Handle)){
		ret=bini_ptr[Handle];
	}else{
		ret=(bini*)(NULL);
	}
	return ret;
};

int GetNewHandle(){
	int new_handle=0;
	while(new_handle==0 || bini_ptr.count(new_handle)){
		new_handle=rand();
	}
	return new_handle;
};

bini* NewBini(int handle){
	bini* ptr=new bini;
	ptr->ini.clear();
	bini_ptr.insert(make_pair(handle,ptr));
	return ptr;
}

void DeleteBini(int handle){
	bini* ptr=bini_ptr[handle];
	delete ptr;
	bini_ptr.erase(handle);
}


//======================================
//@ݒ֐
//======================================
void BiniSetSavePass(int Handle,const char PassStr[]){
	bini* ptr=GetBiniPtr(Handle);
	if(ptr!=NULL){
		if(PassStr[0]!=NULL){
			int i=0;
			int n=0;
			while(i<8 && PassStr[i]!=NULL){
				ptr->pass[i]=PassStr[i];
				i++;
			}
			while(i<8){//8ɖȂ͓Kɖ߂
				ptr->pass[i]=(char)(i*32);
				i++;
			}
			ptr->pass[8]='\0';
		}else{
			for(int i=0;i<sizeof(ptr->pass);i++){
				ptr->pass[i]='\0';
			}
		}
	}
};

int BiniSetCompressFlag(int Flag){
	int ret= COMPRESS_FLAG;
	if(Flag){
		COMPRESS_FLAG=1;
	}else{
		COMPRESS_FLAG=0;
	}
	return ret;
};

int BiniGetCompressFlag(){
	return COMPRESS_FLAG;
};

int BiniSetCastFlag(int CastFlag,int RoundFlag){
	int ret= CAST_FLAG;
	if(RoundFlag != -1){
		if(RoundFlag){
			ROUND_FLAG=1;
		}else{
			ROUND_FLAG=0;
		}
	}
	if(CastFlag != -1){
		if(CastFlag){
			CAST_FLAG=1;
		}else{
			CAST_FLAG=0;
		}
	}
	return ret;
};

int BiniGetCastFlag(){
	return CAST_FLAG;
};

int BiniGetRoundFlag(){
	return ROUND_FLAG;
};

//======================================
//@I[vEN[Y֐
//======================================

int BiniOpen(const TCHAR FileName[],const char PassStr[],int AutoMakeFlag){
	if(bini_ptr.size()>=BINI_OPEN_MAX)return -1;//őǂݍݐ𒴂Ă甲
	//nh
	int handle=GetNewHandle();
	//t@CJēǂݍ
	ifstream ifs(FileName,ios::in|ios::binary);
	if(ifs){//t@C̃I[vɐ
		vector<BYTE> dat;//΂ӂ
		int size=(unsigned int)(ifs.seekg(0,ios::end).tellg());
		ifs.seekg(0,ios::beg);
		dat.resize(size);
		ifs.read((char*)&dat[0],size);
		ifs.close();
		//IuWFNgēǂݍ
		bini* ptr=NewBini(handle);
		BiniSetSavePass(handle,PassStr);
		if(bini_ptr[handle]->ini_make(dat,ptr->pass)==-1){
			DeleteBini(handle);
			return -1;
		}
		//݊JĂt@CpXۑ
		_tcscpy_s(ptr->file_path,PASS_MAX,FileName);
		return handle;
	}else{
		if(AutoMakeFlag){
			//NX
			bini* ptr=NewBini(handle);
			BiniSetSavePass(handle,PassStr);
			//݊JĂt@CpXۑ
			_tcscpy_s(&ptr->file_path[0],PASS_MAX,FileName);
			return handle;
		}else{
			return -1;
		}
	}
};

int BiniOpenFromBinary(const char* BinaryPtr,int Size,const char PassStr[],int AutoMakeFlag){
	if(bini_ptr.size()>=BINI_OPEN_MAX)return -1;//őǂݍݐ𒴂Ă甲
	//nh
	int handle=GetNewHandle();
	//vectorɈڂ
	vector<BYTE> dat;//΂ӂ
	dat.resize(Size);
	memcpy_s(&dat[0],Size,BinaryPtr,Size);
	//dat.assign(Size,*BinaryPtr);
	//IuWFNgēǂݍ
	bini* ptr=NewBini(handle);
	BiniSetSavePass(handle,PassStr);
	if(bini_ptr[handle]->ini_make(dat,ptr->pass)==-1){
		if(AutoMakeFlag){
			//NX
			ptr->init();
			BiniSetSavePass(handle,PassStr);
			//݊JĂt@CpXۑ
			_tcscpy_s(ptr->file_path,PASS_MAX,_T("\0"));
			return handle;
		}else{
			DeleteBini(handle);
			return -1;
		}
	}else{
		//݊JĂt@CpXۑ
		_tcscpy_s(ptr->file_path,PASS_MAX,_T("\0"));
		return handle;
	}
};

int BiniFileMake(const TCHAR FileName[],const char PassStr[]){
	if(bini_ptr.size()>=BINI_OPEN_MAX)return -1;//őǂݍݐ𒴂Ă甲
	int handle=GetNewHandle();
	bini* ptr=NewBini(handle);
	BiniSetSavePass(handle,PassStr);
	_tcscpy_s(ptr->file_path,PASS_MAX,FileName);
	return handle;
};

int BiniSave(int Handle){
	return BiniSaveAs(Handle,_T("\0"),0);
};

int BiniSaveAs(int Handle,const TCHAR FileName[],int PathSetFlag){
	if(bini_ptr.count(Handle)==0)return -1;//sȃnhȂ甲
	bini* ptr=bini_ptr[Handle];
	if(!ptr->file_path[0] && !FileName[0])return -1;//ǂ̃pXNULLȂ甲
	PSTRING filename((FileName[0]!=_T('\0'))?FileName:ptr->file_path);
	vector<BYTE> dat;//΂ӂ
	//opoCi
	int encode_flag=ptr->pass[0]?1:0;
	ptr->binary_make(dat,encode_flag,COMPRESS_FLAG,ptr->pass);
	//pXJĂɏ㏑
	DirectoryMake(filename.c_str());
	ofstream ofs(filename.c_str(),ios::out|ios::binary);
	if(!ofs)return -1;//I[vs甲
	unsigned int size=dat.size();
	ofs.write((char*)&dat[0],size);
	ofs.close();
	//JĂt@CpX
	if(FileName[0] || PathSetFlag){//t@CpXw肳ĂăI[vpXNULLȂ
		_tcscpy_s(ptr->file_path,PASS_MAX,FileName);
	}
	return 0;
};

int BiniClose(int Handle){
	if(bini_ptr.count(Handle)){
		DeleteBini(Handle);
		return 0;
	}else{	
		return -1;
	}
};

int BiniCloseAll(){
	while(bini_ptr.size()){
		if(BiniClose(bini_ptr.end()->first)!=0){
			return -1;
		}
	}
	return 0;
};

//======================================
//@lǂݏ֐
//======================================
int BiniSetInt(int Handle,const char Section[],const char Key[],BINI_INT Value){
	if(bini_ptr.count(Handle)){
		bini_ptr[Handle]->set(string(Section),string(Key),Value);
		return 0;
	}else{
		return -1;
	}
};

int BiniSetFloat(int Handle,const char Section[],const char Key[],BINI_FLOAT Value){
	if(bini_ptr.count(Handle)){
		bini_ptr[Handle]->set(string(Section),string(Key),Value);
		return 0;
	}else{
		return -1;
	}
};

int BiniSetString(int Handle,const char Section[],const char Key[],BINI_STRING Value){
	if(bini_ptr.count(Handle)){
		bini_ptr[Handle]->set(string(Section),string(Key),Value);
		return 0;
	}else{
		return -1;
	}
};

int BiniSetStringFromFile(int Handle,const char Section[],const char Key[],const TCHAR FilePath[]){
	if(bini_ptr.count(Handle)){
		ifstream ifs(FilePath,ios::in|ios::binary);
		if(!ifs)return -1;
		unsigned int size=(unsigned int)(ifs.seekg(0,ios::end).tellg());
		ifs.seekg(0,ios::beg);
		vector<BYTE> vec;
		vec.clear();
		vec.resize(size);
		ifs.read((char*)&vec[0],size);
		ifs.close();
		string val;
		val.resize(size);
		for(unsigned int i=0;i<size;i++){
			val[i]=vec[i];
		}
		bini_ptr[Handle]->set(string(Section),string(Key),val);
		return 0;
	}else{
		return -1;
	}
};

BINI_INT BiniGetInt(int Handle,const char Section[],const char Key[],BINI_INT Default){
	if(bini_ptr.count(Handle)){
		return bini_ptr[Handle]->get_int(string(Section),string(Key),CAST_FLAG,ROUND_FLAG,Default);
	}else{
		return Default;
	}
};

BINI_FLOAT BiniGetFloat(int Handle,const char Section[],const char Key[],BINI_FLOAT Default){
	if(bini_ptr.count(Handle)){
		return bini_ptr[Handle]->get_float(string(Section),string(Key),CAST_FLAG,Default);
	}else{
		return Default;
	}
};

BINI_STRING BiniGetString(int Handle,const char Section[],const char Key[],BINI_STRING Default){
	if(bini_ptr.count(Handle)){
		return bini_ptr[Handle]->get_string(string(Section),string(Key),Default);
	}else{
		return Default;
	}
};

BINI_STRING BiniGetString(int Handle,const char Section[],const char Key[],const char Default[]){
	if(bini_ptr.count(Handle)){
		return bini_ptr[Handle]->get_string(string(Section),string(Key),Default);
	}else{
		return Default;
	}
};

char* BiniGetString(int Handle,const char Section[],const char Key[],char* Dest,int BufSize,const char Default[]){
	if(bini_ptr.count(Handle)){
		if(Dest){
			strcpy_s(Dest,BufSize,bini_ptr[Handle]->get_string(string(Section),string(Key),Default).c_str());
			return Dest;
		}else{
			return NULL;
		}
	}else{
		strcpy_s(Dest,BufSize,Default);
		return Dest;
	}
};

int BiniGetStringLength(int Handle,const char Section[],const char Key[]){
	if(bini_ptr.count(Handle)){
		if(bini_ptr[Handle]->ini[Section][Key].type==3){
			return (int)((string*)bini_ptr[Handle]->ini[Section][Key].ptr)->size();
		}else{
			return -1;
		}
	}else{
		return -1;
	}
};

//lt@Co֐
 
int BiniSaveValueToFile(int Handle,const char Section[],const char Key[],const TCHAR FilePath[],int AppendFlag){
	if(bini_ptr.count(Handle) && BiniKeyExist(Handle,Section,Key)>0){
		ofstream ofs(FilePath,AppendFlag?(ios::app|ios::binary):(ios::out|ios::binary));
		if(!ofs)return -1;
		vector<BYTE> vec;
		vec.clear();
		switch(bini_ptr[Handle]->ini[Section][Key].type){
			case 1://Int
				vec.resize(sizeof(BINI_INT));
				memcpy(&vec[0],bini_ptr[Handle]->ini[Section][Key].ptr,sizeof(BINI_INT));
				break;
			case 2://Float
				vec.resize(sizeof(BINI_FLOAT));
				memcpy(&vec[0],bini_ptr[Handle]->ini[Section][Key].ptr,sizeof(BINI_FLOAT));
				break;
			case 3://string
				vec.resize(((string*)bini_ptr[Handle]->ini[Section][Key].ptr)->size());
				for(unsigned int i=0;i<((string*)bini_ptr[Handle]->ini[Section][Key].ptr)->size();i++){
					vec[i]=((string*)bini_ptr[Handle]->ini[Section][Key].ptr)->at(i);
				}
				break;
		}
		ofs.write((char*)&vec[0],vec.size());
		ofs.close();
		return 0;
	}else{
		return -1;
	}
};

int BiniSaveStringToMem(int Handle,const char Section[],const char Key[],char* Dest,int BufSize){
	if(bini_ptr.count(Handle) && BiniKeyExist(Handle,Section,Key)>0){
		switch(bini_ptr[Handle]->ini[Section][Key].type){
			case 1://Int
				return -1;
				break;
			case 2://Float
				return -1;
				break;
			case 3://string
				if((int)((string*)bini_ptr[Handle]->ini[Section][Key].ptr)->size()<BufSize)return -1;
				unsigned int size = ((string*)bini_ptr[Handle]->ini[Section][Key].ptr)->size();
				for(unsigned int i=0;i<size;i++){
					Dest[i]=((string*)bini_ptr[Handle]->ini[Section][Key].ptr)->at(i);
				}
				break;
		}
		return 0;
	}else{
		return -1;
	}
};


//l`FbN֐

int BiniSectionExist(int Handle,const char Section[]){
	if(bini_ptr.count(Handle)==0)return -1;
	return bini_ptr[Handle]->check_section(Section);
};

int BiniKeyExist(int Handle,const char Section[],const char Key[]){
	if(bini_ptr.count(Handle)==0)return -1;
	return bini_ptr[Handle]->check_key(Section,Key);
};

int BiniKeyExistInt(int Handle,const char Section[],const char Key[]){
	if(bini_ptr.count(Handle)==0)return -1;
	return bini_ptr[Handle]->check_key(Section,Key,1);
};

int BiniKeyExistFloat(int Handle,const char Section[],const char Key[]){
	if(bini_ptr.count(Handle)==0)return -1;
	return bini_ptr[Handle]->check_key(Section,Key,2);
};

int BiniKeyExistString(int Handle,const char Section[],const char Key[]){
	if(bini_ptr.count(Handle)==0)return -1;
	return bini_ptr[Handle]->check_key(Section,Key,3);
};


//l폜֐

int BiniDeleteSection(int Handle,const char Section[]){
	if(bini_ptr.count(Handle)==0)return -1;
	string sec=Section;
	if(bini_ptr[Handle]->ini.find(sec)!=bini_ptr[Handle]->ini.end()){
		for(MAP<string,item>::iterator it=bini_ptr[Handle]->ini[sec].begin();it!=bini_ptr[Handle]->ini[sec].end();it++){
			it->second.clear();
		}
		bini_ptr[Handle]->ini.erase(sec);
		return 0;
	}else{
		return -1;
	}
};

int BiniDeleteKey(int Handle,const char Section[],const char Key[]){
	if(bini_ptr.count(Handle)==0)return -1;
	string sec=Section;
	string key=Key;
	if(bini_ptr[Handle]->ini.find(sec)!=bini_ptr[Handle]->ini.end()){
		if(bini_ptr[Handle]->ini[sec].find(key)!=bini_ptr[Handle]->ini[sec].end()){
			bini_ptr[Handle]->ini[sec][key].clear();
			bini_ptr[Handle]->ini[sec].erase(key);
			return 0;
		}else{
			return -1;
		}
	}else{
		return -1;
	}
};

//======================================
//@̑̊֐
//======================================
int BiniIni(int Handle,const TCHAR FileName[]){
	if(bini_ptr.count(Handle)==0)return -1;//ǂݍ܂ĂȂ甲
	if(!FileName[0])return -1;//pXNULLȂ甲
	PSTRING filename(FileName);
	//܂ŊJĂpXJĂɏ㏑
	DirectoryMake(filename.c_str());
	ofstream ofs(filename.c_str(),ios::out);
	if(!ofs)return -1;//I[vs甲
	ofs.setf(ios_base::fixed,ios_base::floatfield);
	for(MAP<string,MAP<string,item>>::iterator it=bini_ptr[Handle]->ini.begin();it!=bini_ptr[Handle]->ini.end();it++){
		//I
		ofs << "[" << it->first.c_str() << "]" << endl;
		for(MAP<string,item>::iterator it2=it->second.begin();it2!=it->second.end();it2++){
			switch(it2->second.type){
				case 1://64bit int
					ofs << it2->first.c_str() << "=" << *(BINI_INT*)it2->second.ptr << endl;
					break;
				case 2://64bit float
					ofs << it2->first.c_str() << "=" << *(BINI_FLOAT*)it2->second.ptr << endl;
					break;
				case 3://string
					ofs << it2->first.c_str() << "=" << (*(string*)it2->second.ptr).c_str() << endl;
					break;
			}
		}
		ofs << endl;
	}
	ofs.close();
	//JĂt@CpX
	return 0;
};

//======================================
//@Ŏg֐
//======================================

//======================================
//@fBNgCN
//======================================

//pXnƕۑ\ȂƂ܂ŃfBNgĂ
int DirectoryMake(const TCHAR Path[]){
	PSTRING str;
	vector<int> vec;
	str.clear();
	str=Path;
	vec.clear();

	int size=str.size(); 
	for(int i=0 ; i<size ; i++){
		if(str[i]==_T('\\') || str[i]==_T('/')){
			vec.push_back(i+1);
		}
	}
	size=vec.size();
	int ret=1;
	for(int i=0;i<size;i++){
		MKDIR(str.substr(0,vec[i]).c_str());
	}
	return ret;
};

//t@CpXt@C𒊏o
PSTRING GetFileName(const TCHAR Path[]){
	PSTRING str;
	str.clear();
	str=Path;

	long long int size=str.size(); 
	unsigned int last_en=0;
	for(int i=0 ; i<size ; i++){
		if(str[i]==_T('\\') || str[i]==_T('/')){
			last_en=i+1;
		}
	}
	PSTRING ret=str.substr(last_en);

	return ret;
};


//======================================
//@kE𓚁EnbVvZ֐
//======================================

long long int Compress(vector<BYTE>& dat){
	vector<BYTE> src=dat;//\[XpzɃ\[XƂăRs[
	unsigned int src_size=src.size();//f[^̃TCY
	dat.clear();//zo͗pzƂĎg߂肠`
	//ԏȍȂoCgT
	unsigned int byte_count[256];
	for(int i=0;i<256;i++)byte_count[i]=0;
	for(unsigned int i=0;i<src_size;i++){
		byte_count[src[i]]++;
	}
	BYTE key;//L[
	unsigned int buf=0;
	for(int i=0;i<256;i++){
		if(i){
			if(buf>byte_count[i]){
				key=i;
				buf=byte_count[i];
			}
		}else{
			key=0;
			buf=byte_count[i];
		}
	}
	//kt@C̃wb_ǉiƂĂL[Ȃ񂾂ǁj
	dat.push_back(key);
	//t@C𑖍Ĉk
	int same_len;
	int same_max;
	int max_index;
	long long int pt=0;
	while(pt<src_size){
		same_max=max_index=same_len=-1;
		//255oCg܂őkĒׂcc
		for(int i=0;i<256;i++){
			if((int)(pt-i) >= 0){//kă\[XJnʒuȏゾ
				//vĂԂ񂾂񂵂ĈvJEgI
				for(same_len=0;same_len<i;same_len++){
					//t@C̏I[ȏ̈ʒuAvĂȂɏo炨
					if((unsigned int)(pt+same_len)>=src_size)break;
					if(src[(unsigned int)(pt+same_len)]!=src[(unsigned int)(pt-i+same_len)])break;
				}
				//4oCgȏvĂővXV!
				if(same_len>3 && same_max<same_len){
					same_max=same_len;
					max_index=i;
				}
			}
		}
		//óI
		if(max_index==-1){//vӏȂcc
			dat.push_back(src[(unsigned int)(pt)]);
			//L[ƈvĂd˂Ă
			if(src[(unsigned int)(pt)]==key){
				dat.push_back(src[(unsigned int)(pt)]);
			}
			pt++;//̕[
		}else{//ǂɈvcc
			dat.push_back(key);//L[
			//̂ڂoCg(L[Ƃ̃obeBOh߂ɁAL[Ȃ0x00ɂ)
			if(max_index==key){
				dat.push_back((BYTE)(0x00));
			}else{
				dat.push_back((BYTE)(max_index));
			}
			dat.push_back((BYTE)same_max);//v
			pt+=same_max;//vi߂Ď[
		}
	}
	//
	return dat.size();
};


long long int Expand(vector<BYTE>& dat){
	vector<BYTE> src;
	unsigned int src_size=dat.size()-1;
	src.resize(src_size);//wb_TCY
	memcpy(&src[0],&dat[1],src_size);
	BYTE key=dat[0];//L[
	dat.clear();//ɂāAf[^͂ɋlߍ
	
	//𓀂
	unsigned int pt=0;
	int index;
	int same_len;
	//kt@C̍Ō܂ł܂킵܂킵
	while(pt<src_size){
		//L[
		if(src[pt]==key){
			pt++;
			if(src[pt]==key){//2AL[L[̂̂Ƃďo
				dat.push_back(src[pt]);
				pt++;
			}
			else{//AĂȂIL[˂IIĎ
				index=src[pt];//ǂ萔
				if(index==0){//L[Ɠȏゾ1ZĂ߂
					index=key;
				}
				pt++;
				same_len=src[pt];//vĂ钷
				//̂ڂ萔ÖʒuvԂo
				unsigned int last=dat.size();
				for(int i=0;i<same_len;i++){
					dat.push_back(dat[last-index+i]);
				}
				pt++;
			}
		}else{
			//L[Ȃ炻̂܂܏o
			dat.push_back(src[pt]);
			pt++;
		}
	}
	return dat.size();//WJf[^̃TCYԂ
};


void Encode(vector<BYTE>& str,const char pass[9]){
	unsigned int size=str.size();
	for(unsigned int i=0;i<size;i++){
		str[i]=~str[i];//]
	}
	if(!pass[0]){
		for(unsigned int i=0;i<size;i++){
			str[i]^=pass[i%8];//xor
		}
	}
	for(unsigned int i=0;i<size;i++){
		str[i]+=i*8;//KɑĒl炷
	}
};

void Decode(vector<BYTE>& str,const char pass[9]){
	unsigned int size=str.size();
	for(unsigned int i=0;i<size;i++){
		str[i]-=i*8;//KɑĒl炵̂߂
	}
	if(!pass[0]){
		for(unsigned int i=0;i<size;i++){
			str[i]^=pass[i%8];//xor
		}
	}
	for(unsigned int i=0;i<size;i++){
		str[i]=~str[i];//]
	}
};

unsigned long long int GetHash(vector<BYTE>& str,unsigned start){
	unsigned int size=str.size()-start;
	unsigned long long int hash=0;
	BYTE* ptr[8];
	for(int i=0;i<8;i++){
		ptr[i]=((BYTE*)&hash)+(sizeof(BYTE)*i);//hash8oCg̔zƂĈ
	}
	for(unsigned int i=0;i<size;i++){
		*(ptr[i%8])=(BYTE)(*(ptr[i%8])+(~str[i+start])+i);
	}
	if(hash==0)hash++;//nbVl0ɂȂĂ܂1ɂĂ
	return hash;
};

unsigned long long int SetPassToHash(unsigned long long int hash,const char pass[9]){
	if(pass[0]!=NULL){
		BYTE* ptr[8];
		for(int i=0;i<8;i++){
			ptr[i]=((BYTE*)&hash)+(sizeof(BYTE)*i);
		}
		for(unsigned int i=0;i<8;i++){
			*(ptr[i])^=pass[i];
		}
		return hash;
	}else{
		return hash;
	}
};


//======================================
//@loCgɂoCgʂ̌^ɂ
//======================================

unsigned long long int ByteToULLInt(BYTE* ptr){
	unsigned long long int* ret;
	ret=(unsigned long long int*)ptr;

	return *ret;
};

long long int ByteToLLInt(BYTE* ptr){
	long long int* ret;
	ret=(long long int*)ptr;

	return *ret;
};

unsigned int ByteToUInt(BYTE* ptr){
	unsigned int* ret;
	ret=(unsigned int*)ptr;

	return *ret;
};

double ByteToDouble(BYTE* ptr){
	double* ret;
	ret=(double*)ptr;

	return *ret;
};

void ByteToString(BYTE* ptr,string& str,unsigned int size){
	str.clear();
	str.resize(size);
	for(unsigned int i=0;i<size;i++){
		str[i]=*(ptr+i);
	}
};

void AddStringForByteVector(vector<BYTE>& vec,const string& str){
	int size=str.size();
	for(int i=0;i<size;i++){
		vec.push_back(str[i]);
	}
};
